package gov.va.vinci.dart.db.impl;

import java.util.List;

import gov.va.vinci.dart.biz.PreparatoryStudy;
import gov.va.vinci.dart.db.PreparatoryStudyDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import javax.persistence.Query;

public class PreparatoryStudyDAOImpl extends HibernateDAO implements PreparatoryStudyDAO {

	@Override
	public void save(final PreparatoryStudy study) {
		if (study == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(study);
	}
	
	@Override
	public PreparatoryStudy findById(final int activityId) {
		Query q = createQuery("from PreparatoryStudy where id=:aid");
		q.setParameter("aid", activityId);
		return (PreparatoryStudy)q.getSingleResult();
	}

	@Override
	public PreparatoryStudy findByShortName(final String name) {
		
		Query query = createQuery("from PreparatoryStudy where name like :rsid");
		query.setParameter("rsid", name);
		return (PreparatoryStudy)query.getSingleResult();
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<PreparatoryStudy> listAll() {
		Query query = createQuery("from PreparatoryStudy");
		return (List<PreparatoryStudy>)query.getResultList();
	}
}
